// Game.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Game.h"

#include "GameFrame.h"
#include "Animation.h"

#include <mmsystem.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//***************************************************************************
// The one and only CGameApp object
//***************************************************************************

//CGameApp theApp;

//-----------------------------------------------------------------------------
// default constructor
//-----------------------------------------------------------------------------
CGameApp::CGameApp()
{
  m_bPlaying = FALSE;
  m_displayWidth = 640;
  m_displayHeight = 480;
  CAnim::SetDisplayWidth(m_displayWidth);
}

//-----------------------------------------------------------------------------
// InitInstance
//-----------------------------------------------------------------------------
BOOL CGameApp::InitInstance()
{
	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	m_pMainWnd = GetNewFrame();
	ASSERT(m_pMainWnd != NULL);

	m_pMainWnd->ShowWindow(SW_SHOWNORMAL);
  ShowCursor(FALSE);

	return TRUE;
}

//-----------------------------------------------------------------------------
// virtual GetNewFrame
//-----------------------------------------------------------------------------
CWnd* CGameApp::GetNewFrame()
{
  return new CGameFrame();
}


//-----------------------------------------------------------------------------
// GetGameFrame
//-----------------------------------------------------------------------------
CGameFrame* CGameApp::GetGameFrame()
{
  return (CGameFrame*)m_pMainWnd;
}

//-----------------------------------------------------------------------------
// virtual StartPlay
//-----------------------------------------------------------------------------
void CGameApp::StartPlay()
{
  m_bPlaying = TRUE;
}

//-----------------------------------------------------------------------------
// virtual StopPlay
//-----------------------------------------------------------------------------
void CGameApp::StopPlay()
{
  m_bPlaying = FALSE;
}

//-----------------------------------------------------------------------------
// virtual Run
//-----------------------------------------------------------------------------
int CGameApp::Run() 
{
	ASSERT_VALID(this);

  // Initialize the graphics
  if (!GetGameFrame()->InitGraphics())
  {
    GetGameFrame()->KillGraphics();
    return ExitInstance();
  }

  // Give most of the processor time to the application (but not all!)
  SetThreadPriority(THREAD_PRIORITY_HIGHEST);

	// acquire and dispatch messages until a WM_QUIT message is received.
	for (;;)
	{
		if (::PeekMessage(&m_msgCur, NULL, NULL, NULL, PM_NOREMOVE))
		{
			// pump message, but quit on WM_QUIT
			if (!PumpMessage())
      {
        GetGameFrame()->KillGraphics();
        GetGameFrame()->DestroyWindow();

        return ExitInstance();
      }
		}

		if (m_bPlaying)
		{
			if (!GetGameFrame()->UpdateGame())
      {
        StopPlay();
        PostQuitMessage(0);
      }
		}
    else
    {
      ::WaitMessage();
    }
	}

	ASSERT(FALSE);  // not reachable
}

BEGIN_MESSAGE_MAP(CGameApp, CWinApp)
	//{{AFX_MSG_MAP(CGameApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

