/*===========================================================================
SOLAR v0.95.2 solar :: Module ..\solar\user.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "user.h"

/*
 * Function: user_options
 * Purpose : Main Solar user interface
 * Return  : 0 = exit Solar
             1 = batch packet
             2 = reply processing
            -1 = error
*/

int user_options()
{
  void solar_command_menu();

  char command[80];
  int  save_flag   = 0;
  int  error_count = 0;

  strcpy(command,"XXX");
  while ((toupper(command[0]) != 'Q') && (toupper(command[0]) != 'E'))
	{
    if (strnicmp(command,"BA",2) == 0) goto BatchExit;
    if (strnicmp(command,"RE",2) == 0) goto ReplyExit;
    if ((strnicmp(command,"ME",2) == 0) || (command[0] == '\?'))
		{
      solar_command_menu();
      strcpy(command,"XXX");
		}

    /* HELP command */
    if (strnicmp(command,"H",1) == 0)
		{
      if (strcmp(help_path,"NONE") == 0)
      {
        strcpy(help_path,waffle_path);
        strcat(help_path,"\\help\\solar");
      }
			if (view_file(help_path) != 0)
      {
        RPrintf("\nHelp for Solar has not been installed.\n");
      }
			strcpy(command,"XXX");
		}

    /* SHOW command */
    if (strnicmp(command,"SH",2) == 0)
		{
			solar_settings();
			strcpy(command,"XXX");
		}

    /* MAIL command */
    if (strnicmp(command,"MA",2) == 0)
		{
      if (set_send_mail("y") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nInclude Mail: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NOMAIL command */
    if (strnicmp(command,"NOM",3) == 0)
		{
      if (set_send_mail("n") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nInclude Mail: NO\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* MMDF command */
    if (strnicmp(command,"MM",2) == 0)
		{
      if (set_mail_type("M") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nMail Format: MMDF\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* UNIX command */
    if (strnicmp(command,"UN",2) == 0)
		{
      if (set_mail_type("m") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nMail Format: Unix\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* BMAIL command */
    if (strnicmp(command,"BM",2) == 0)
    {
      if (set_mail_type("b") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nMail Format: 8-bit Binary\n\n");
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NODELETE command */
    if (strnicmp(command,"NOD",3) == 0)
		{
      if (set_delete_mail("n") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nDelete Mail: NO\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* DELETE command */
    if (strnicmp(command,"D",1) == 0)
		{
      if (set_delete_mail("y") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nDelete Mail: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* LIST command */
    if (strnicmp(command,"L",1) == 0)
		{
      if (set_send_list("y") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nInclude Msg Area List: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NOLIST command */
    if (strnicmp(command,"NOL",3) == 0)
		{
      if (set_send_list("n") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nInclude Msg Area List: NO\n\n");
      save_flag = 1;
      strcpy(command,"XXX");
		}

    /* NOHEADER command */
    if (strnicmp(command,"NOH",3) == 0)
		{
      if (set_news_index("n") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nHeader Format: No headers\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* FULL HEADERS command */
    if (strnicmp(command,"F",1) == 0)
		{
      if (set_news_index("c") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nHeader Format: Full C-news\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* PARTIAL HEADERS command */
    if (strnicmp(command,"PA",2) == 0)
		{
      if (set_news_index("C") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nHeader Format: Partial C-news\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* USENET command */
    if (strnicmp(command,"US",2) == 0)
    {
      if (set_news_type("u") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nNews message area type: USENET\n\n");
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* BNEWS command */
    if (strnicmp(command,"BN",2) == 0)
    {
      if (set_news_type("B") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nNews message area type: 8-bit Binary\n\n");
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* INDEX ONLY command */
    if (strnicmp(command,"I",1) == 0)
    {
      if (set_news_type("i") != 0)
        RPrintf("\n%s\n",_slrerr);
      else
        RPrintf("\nNews message area type: Index-Only\n\n");
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* WAFFLE command */
    if (strnicmp(command,"W",1) == 0)
		{
			use_wafjoin = YES;
      RPrintf("\nUsing Waffle's JOIN file\n\n");
			strcpy(command,"XXX");
			save_flag = 1;
		}

    /* SOLAR command */
    if (strnicmp(command,"SO",2) == 0)
		{
			use_wafjoin = NO;
      RPrintf("\nUsing Solar's %s file\n\n",NEWSRC);
			strcpy(command,"XXX");
			save_flag = 1;
		}

    /* 2WAFFLE command */
    if (strnicmp(command,"2W",2) == 0)
		{
      if (newsrc2join() == 0)
        RPrintf("\n%s exported to JOIN\n\n",NEWSRC);
      else
        RPrintf("\n%s\n\n", _slrerr);
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* 2SOLAR command */
    if (strnicmp(command,"2S",2) == 0)
		{
      if (join2newsrc() == 0)
        RPrintf("\nJOIN exported to %s\n\n",NEWSRC);
      else
        RPrintf("\n%s\n\n", _slrerr);
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* SUBSCRIBE command */
    if (strnicmp(command,"SU",2) == 0)
    {
/*
      if (use_wafjoin == YES)
      {
        if (join2newsrc() == -1) goto ErrorExit;
      }
*/
      switch (build_newsrc()) {
        case -1   : goto ErrorExit;
        default   : break;
      }
/*
      if (use_wafjoin == YES)
      {
        if (newsrc2join() == -1) goto ErrorExit;
      }
*/
      strcpy(command,"XXX");
    }

    /* PROTOCOL command */
    if (strnicmp(command,"PR",2) == 0)
		{
      if (select_protocol() != 0) goto ErrorExit;
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* COMPRESS command */
    if (strnicmp(command,"C",1) == 0)
		{
      if (select_compress() != 0) goto ErrorExit;
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* Unknown command */
    if (stricmp(command,"XXX") != 0)
		{
      RPrintf("\n%s: unknown command\n\n",command);
			strcpy(command,"XXX");
      error_count++;
      if (error_count > stupid_user)
      {
        solar_command_menu();
        error_count = 0;
      }
    }

    while ((stricmp(command,"XXX") == 0) || (!(strlen(command) > 0)))
    {
      if (save_flag == 1)
      {
        if ((save_flag = write_options()) != 0) goto ErrorExit;
        save_flag = 0;
      }
      if (timechk(time_left) != 0) goto ErrorExit;
      RPrintf("%s",SOLAR_PROMPT);
			Rgets(command);
    }
  }
QuitExit:
  return 0;
BatchExit:
/*
  if (use_wafjoin == YES)
  {
    if (join2newsrc() == -1) goto ErrorExit;
  }
*/
  return 1;
ReplyExit:
  return 2;
ErrorExit:
  return -1;
}

void solar_command_menu()
{
  if (view_file(menu_path) != 0)
  {
    RPrintf("\nMenu for Solar has not been installed.\n");
  }
  return;
}

/*
Function: select_compress()
Purpose : Allow user to select from available compression methods.
Return  : Compression method string.
*/

int select_compress()
{
  FILE *config_file = fopen(config_path,"rt");
  char buf[128];
  int  idx = 0, choice = 0, temp = 0;
  char *p;

  if (!config_file)
  {
    sprintf(_slrerr,"select_compress(): error opening %s for reading.",config_path);
    goto ErrorExit;
  }

  fprintf(stdout,"\n");
  fprintf(stdout,"Current compression method: %s\n",compress);

  while (((fgets(buf,128,config_file)) != NULL) && (idx < 10))
	{
		if (strnicmp(buf,"compress",8) == 0)
    {
			idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"select_compress(): Invalid \"compress\" line in config file.");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"select_compress(): Invalid \"compress\" line in config file.");
        goto ErrorExit;
      }
      fprintf(stdout,"%u] %s\n",idx,p);
    }
	}
  if (idx < 1)
  {
    strcpy(_slrerr,"select_compress(): No installed compression options.");
    goto ErrorExit;
  }

  RPrintf("\nEnter # : ");
  temp = getchar();
  fflush(stdin);
  RPrintf("\n");

  if (temp == 13) goto GoodExit;
  choice = temp - 48;
  if ((choice < 1) || (choice > idx))
	{
    fprintf(stdout,"Compression method still: %s\n\n",compress);
    goto GoodExit;
  }
  fseek(config_file,0L,SEEK_SET);
	idx = 0;
  while ((fgets(buf,128,config_file)) != NULL)
  {
    if (strnicmp(buf,"compress",8) == 0)
    {
      idx++;
			if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"select_compress(): Invalid \"compress\" line in config file.");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"select_compress(): Invalid \"compress\" line in config file.");
        goto ErrorExit;
      }
      if (idx == choice)
      {
        strcpy(compress,p);
        fprintf(stdout,"Compression Method: %s\n\n",compress);
        break;
			}
    }
  }
GoodExit:
  fclose(config_file);
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}

/*
Function: select_protocol()
Purpose : Allow user to select from available compression methods.
Return  : Compression method string.
*/

int select_protocol()
{
	FILE *config_file = fopen(config_path,"rt");
	char buf[128];
  int  idx = 0, choice = 0, temp = 0;
	char *p;

  if (!config_file)
  {
    sprintf(_slrerr,"select_protocol(): Error opening %s for reading.",config_path);
    goto ErrorExit;
  }
  fprintf(stdout,"\n");
  fprintf(stdout,"Current protocol: %s\n",protocol);
  while (((fgets(buf,128,config_file)) != NULL) && (idx < 10))
  {
    if (strnicmp(buf,"receive",7) == 0)
    {
			idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"select_protocol(): Invalid \"receive\" line in config file.");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
			{
        strcpy(_slrerr,"select_protocol(): Invalid \"receive\" line in config file.");
        goto ErrorExit;
      }
      fprintf(stdout,"%u] %s\n",idx,p);
    }
	}
	if (idx < 1)
	{
    strcpy(_slrerr,"select_protocol(): No installed protocol options.");
    goto ErrorExit;
	}

  fprintf(stdout,"\nEnter # : ");
	temp = getchar();
  fprintf(stdout,"\n");
  fflush(stdin);
  if (temp == 13) return 0;
  choice = temp - 48;
	if ((choice < 1) || (choice > idx))
	{
    fprintf(stdout,"Protocol is still %s\n\n",protocol);
    goto GoodExit;
  }

  fseek(config_file,0L,SEEK_SET);
  idx = 0;
	while ((fgets(buf,128,config_file)) != NULL)
	{
    if (strnicmp(buf,"receive",7) == 0)
    {
      idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"select_protocol(): Invalid \"receive\" line in config file.");
        goto ErrorExit;
			}
      if (idx == choice)
      {
        strcpy(protocol,p);
        fprintf(stdout,"Transfer Protocol: %s\n\n",protocol );
        break;
      }
    }
  }
GoodExit:
  fclose(config_file);
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}

