{
            ۿ ۿ   ۿ ۿ ۿ       ۿ  ۿ  ۿ
            ۳ ۳   ۳ ۳ ۳      ۿ ۿ ۳
            ۳ ۳   ۳ ۳ ۳      ۳   ۳ ۿ۳
            ۳ ۿ  ۳ ۳      ۳   ۳ ۳۳
            ۳   ۳    ۳   ۳ ۿ  ۳ ۳
                               

{ - Avalon Data File Structures                                                }
{ - Avalon is (C) 1998, Dean Woodside, of Auspisoft                            }
{ - Feel free to distribute to everyone!                                       }
{ - Create EGO's, Utilities, and more for Avalon!                              }

{Hello friend!                                                                }

{ I'm preparing this information file to help others in created 3rdParty stuff }
{ for Avalon.  Feel free to charge anything you wish for your program(s) -- as }
{ we do not charge any type of "royalty" fee on 3rdParty products.             }

{ NOTE - These structs and the following information is based on a programming }
{        language called "Turbo Pascal". If you do not have this language, you }
{        will have to somehow convert these records into your own format.      }

{ Hey, you want to write an EGO?  Excellent!  It is really quite simple.  It's }
{ basically a three step process, like this:                                   }
{                     1. Read in AVINFO.<x>, where <x> is the node number of   }
{                        the current online user.                              }
{                     2. Load up the PLAYER.DAT file, and find the player name }
{                        that matches the name in the AVINFO.<x> file.         }
{                     3. That's it!  You're on your way -- start your program! }

{ In an update to Avalon soon, we will try to include some sort of EGO devel-  }
{ opment kit to assist those who're experiencing troubles with their program   }
{ or programs.  Well, for now, though, you're on your own. <g>  Here are a few }
{ tips we've tossed around over the past few months which might help you in    }
{ getting your program(s) off the ground:                                      }

{ 1. Download a copy of the latest version of DDPlus - DDPLUS71.ZIP. It should }
{    be available from almost any BBS system in your area, or somewhere on the }
{    Internet.  We used DDPlus to create Avalon.  It is a simple to use kit    }
{    which should easily take care of most of your problems with your program. }
{ 2. To trap errors in your program I suggest using a Unit that is included in }
{    the DDPLUS71.ZIP Archive - ELOG.PAS. It will trap and log all errors that }
{    might occur in your program, and will help you in finding the cause.      }
{ 3. Ask one of your friends who knows TP, or someone in the FidoNet Echo, for }
{    a procedure which will save bad error exits.  What this means is that if, }
{    for some reason, your program has an error and halts - it will not save a }
{    user's new information.   With a procedure/function at the end to save no }
{    matter what type of an exit, your program will run much smoother, regard- }
{    less of what happens while inside the program.  If you cannot find such a }
{    procedure/function, contact Devon Brooks, the Author, and he might be     }
{    able to give you the same procedure that is used to trap exits in Avalon. }
{ 4. There is nothing more that we can really help you out in.    Turbo Pascal }
{    programming experience would be nice - but, the Avalon Author started his }
{    first program in Turbo Pascal when he had NO previous experience.   Thus, }
{    even if you have never looked at TP before you can learn it quite easily. }
{    If you want some assistance from the Avalon Author, feel free to contact  }
{    him anytime.  There are a few different ways, as listed in CONTACT.DOC,   }
{    which would be included in the same archive of which you found this file. }

{ All user variables in PLAYER.DAT are commented here for your convenience.    }

Type UserRecord = Record

Real_Name       : String[40];   { Player's Real Name from the BBS        }
Alias           : String[15];   { User's game Alias in Avalon            }
Date            : String[20];   { Date Flag -- User's last online date   }
Arrived_At      : String[10]; 	{ Time player entered (military time)    }
TimesOn         : Byte;         { # of times this player played Avalon   }
Time_Zone       : Byte;         { Current Time Zone (1 = Medieval,
                                  2 = Present, 3 = Future, 4 = Avalon)   }
Char_Class      : Byte;         { Players Character Class (1 = Warrior,
                                  2 = Necromancer, 3 = Thief)            }
Companion       : String[20];   { Current Companion of this character    }
Hand            : LongInt;      { Currency on Hand                       }
Bank            : LongInt;      { Currency held in the Bank              }
Bank_Ban        : Byte;         { How many days user cannot enter Bank   }
Bank_Rob        : Boolean;      { Has user robbed bank already today?    }
Gender          : Byte;         { Player Gender (1 = Male, 2 = Female)   }
Online          : Boolean;      { If TRUE, player is currently online    }
Str             : Integer;      { Character's Strength Meter             }
Def             : Integer;      { Character's Defense Meter              }
Dex             : Integer;      { Character's Dexterity Meter            }
Wisdom          : Integer;      { Character's Wisdom Meter               }
Know            : Integer;      { Character's Knowledge Meter            }
HP              : Integer;      { Character's Current Health Points      }
HP_Max          : Integer;      { Character's Maximum Health Points      }
MP              : Integer;      { Character's Current Magik Points       }
MP_Max          : Integer;      { Character's Maximum Magik Points       }
Weapon_Name     : String[20];   { Current Weapon Name                    }
Weapon_Num      : Byte;         { Weapon Number (1..10)                  }
Armour_Name     : String[20];   { Current Armour Name                    }
Armour_Num      : Byte;         { Armour Number (1..10)                  }
Charisma        : Integer;      { Just general good looks meter <g>      }
EXP             : LongInt;      { Character's Experience Points          }
Level           : Integer;      { Current Level the character is on      }
Sleep           : Byte;         { Where player is sleeping (1 = Plains,
                                  2 = Inn, 3 = In an EGO)                }
Invested        : LongInt;      { Initial amount which was invested      }
Projected       : LongInt;      { Projected return on an investment      }
Invest_Date     : String[20];   { Date on which the investment was made  }
Invest_Time     : Byte;         { How many days the investment was for   }
Status          : Byte;         { Player Status (1 = Alive, 2 = Dead)    }
On_Today        : Boolean;      { Has this user been on already today?   }
Arrows          : Integer;      { (NOT USED YET) Arrows on hand (Quiver) }
WS_Haggle       : Boolean;      { Has user haggled in Weapon Shop?       }
AS_Haggle       : Boolean;      { Has user haggled in Armour Shop?       }
Mentor_Fought   : Boolean;      { Has user fought their Mentor today?    }
P_Fights        : Integer;      { Player Fights remaining for today      }
M_Fights        : Integer;      { Monster Fights remaining for today     }
Potions         : Integer;      { Healing Potions on this character      }
Elixir          : Boolean;      { Has user bought an Elixir today?       }

End;

{ Here is the format of the Ownership Data File (PROPERTY.DAT).                }

ShopData = Record

Owner           : String[20];   { Name of the owner of the property      }
Price           : LongInt;      { Price for another character to buy it  }

End;

{ Below is the format for the Mentors in Avalon (MENTORS.DAT).                 }

MentorData = Record

Name            : String[20];   { Mentor's Name                          }
Str             : Integer;      { Strength of attack from Mentor         }
Def             : Integer;      { Defensive skill of Mentor              }
Exp             : LongInt;      { Exp req. for user to fight Mentor      }
HP              : Integer;      { Health Points of Mentor                }

End;

{ And, the Monster Data File is below (MONSTERS.DAT).                          }

MonData = Record

Name            : String[20];   { Name of the Monster                    }
Str             : Integer;      { Strength of the Monster's Attack       }
Exp             : LongInt;      { Experience reward when defeated        }
HP              : Integer;      { Health Points of the Monster           }
Gold            : LongInt;      { Currency reward when defeated          }

End;

{ Here we have the SNI Bank of Riches Guard Data File (SNIBANK.DAT).           }

GuardData = Record

Name            : String[15];   { Name of the user who is has Guard Job  }

End;

{ And...finally, here is the format of the 3rd-Party EGO Data File (EGOS.DAT). }

EGOData = Record

EGO_Name   : String[40];        { Name of the EGO in this slot           }
EGO_Path   : String;            { Path to the executable of the EGO      }

End;

{ SOME INFORMATION REGARDING EGO DEVELOPMENT:                                  }
{ We at BFS want to stress the importance of following the set guidelines for  }
{ EGO developers.  When creating your EGO, keep these points in mind:          }
{                             1. A Maximum of 10 EGO's can be in the EGOS.DAT  }
{                                file.  When installing your EGO, check to see }
{                                if 10 EGO's are already installed, to prevent }
{                                possible mix-ups.                             }
{                             2. Please have an option for an uninstall of     }
{                                your EGO.  This must take out ALL the info    }
{                                that your installation procedure entered into }
{                                the EGOS.DAT file.                            }
{                             3. One thing to remember upon installation of    }
{                                your EGO is to check if it's already been     }
{                                installed.  Always a good thing.              }
{ That's it!  Or, at least, that's all we can think of at this point.  To get  }
{ your EGO/Utility/3rdParty product on the list in EGOLIST.TXT, refer to the   }
{ bottom of that file for more information.                                    }

{ Upon Avalon's exit to run an EGO, AVINFO.<x> is created, where <x> is the    }
{ node number that the user is on.  AVINFO.<x> is a drop file.  As your EGO is }
{ loading up, if need be, you might want to read in the AVINFO.<x> file. Below }
{ is the format for this file:                                                 }

{      Line 1 ---> Record Number of the user in the PLAYER.DAT file            }
{      Line 2 ---> Graphics Code.  3 = ANSI Graphics, else ASCII.              }
{      Line 3 ---> Time remaining online                                       }
{      Line 4 ---> ROK Alias of the character                                  }
{      Line 5 ---> First *REAL* Name of the user                               }
{      Line 6 ---> Last *REAL* Name of the user                                }
{      Line 7 ---> Com Port the modem is running on                            }
{      Line 8 ---> Actual Baud Rate                                            }
{      Line 9 ---> Locked Baud Rate					       }

{ That is the format of the AVINFO.<x> file.  A 9-Line drop file format.       }

{ Well, that's all of them!  As mentioned above, if you require assistance in  }
{ regards to the structs shown here, please feel free to contact us anytime.   }

{ Please refer to the EGOLIST.TXT file, included in this archive, for more EGO }
{ and other 3rdParty related products. For your product to be recognized by us }
{ in the EGOLIST.TXT, you must receive the "BFS Stamp of Approval".  More info }
{ is given at the bottom of EGOLIST.TXT.                                       }


Begin
End.
