{Ŀ
                    * ROK Player File Structures *  
                                                                      
                                     ROK, created byDevon Brooks, of 
                                     Blazing Fire Software - (C)1997 
                                                           
                                     Distribute Freely To Everyone!  
                                                                     
                                    Create External EGO's, Utilities 
                              for the SysOp, Bulletins, etc!  
 }

{Hi there!I'm Devon Brooks, the Author of ROK.  I'm writing this STRUCTS.PAS }
{ file for 3rd Party Authors to create stuff for ROK.  Feel free to charge    }
{ anything you wish for your program -- we do not require any "Royalty"fee on }
{ 3rdParty Programs -- so ask for a registration that you see fit.       }

{ One thing I'd like to point out.  ROK automatically passes the node number   }
{ to the EGO.  Thus, your EGO automatically has the node number stored in the  }
{ ParamStr(1) (the first parameter).  Many have asked about this, so here is   }
{ the information.  If you are unclear about this, e-mail us, and we'll help   }
{ you through the programming troubles.                                        }

{ NOTE - These structs and the following information is based on a programming }
{        language called "Turbo Pascal". If you do not have this language, you }
{        will have to somehow convert these records into your own format.      }

{ Hey, you want to write an EGO?  Excellent!  It is really quite simple.  It's }
{ basically a three step process, like this:                                   }
{                     1. Read in ROKINFO.<x>, where <x> is the node number of  }
{                        the current online user.                              }
{                     2. Load up the PLAYER.DAT file, and find the player name }
{                        that matches the name in the ROKINFO.<x> file.        }
{                     3. That's it!  You're on your way -- start your program! }

{ In future versions of ROK, possibly the next version, an EGO Development Kit }
{ will be included in the ROKV*.ZIP Archive to help 3rd Party Authors create a }
{ ROK EGO, or any other program relating to ROK.   Unfortunately, for now, you }
{ are basically on your own.   Here are a few tips to help you out in creating }
{ your own program for ROK :                                                   }

{ 1. Download a copy of the latest version of DDPlus - DDPLUS71.ZIP. It should }
{    be available from almost any BBS system in your area, or somewhere on the }
{    Internet.  We used DDPlus to create ROK. It is a simple to use DoorDriver }
{    which should easily take care of most of your problems with your program. }
{ 2. To trap errors in your program I suggest using a Unit that is included in }
{    the DDPLUS71.ZIP Archive - ELOG.PAS. It will trap and log all errors that }
{    might occur in your program, and will help you in finding the cause.      }
{ 3. Ask one of your friends who knows TP, or someone in the FidoNet Echo, for }
{    a procedure which will save bad error exits.  What this means is that if, }
{    for some reason, your program has an error and halts - it will not save a }
{    user's new information.   With a procedure/function at the end to save no }
{    matter what type of an exit, your program will run much smoother, regard- }
{    less of what happens while inside the program.  If you cannot find such a }
{    procedure/function, contact Devon Brooks, the Author of ROK, and he might }
{    be able to give you the same procedure that is used to trap exits in ROK. }
{ 4. There is nothing more that we can really help you out in.    Turbo Pascal }
{    programming experience would be nice - but, the Author of ROK started his }
{    first program in Turbo Pascal when he had NO previous experience.   Thus, }
{    even if you have never looked at TP before you can learn it quite easily. }
{    If you want some assistance from the ROK Author, feel free to contact him }
{    anytime.  There are quite a few different ways, as listed in CONTACT.DOC, }
{    which would be included in the same archive of which you found this file. }

{ All user variables in PLAYER.DAT are commented here for your convenience.    }

Type UserRecord = Record

Real_Name        : String[40]; { User's REAL Name from the BBS DropFile   }
Alias            : String[15]; { User's Alias Name in ROK                 }
Date             : String[15]; { Date Flag -- User's last online date     }
Status           : Byte;       { Current Player Status (1 = Alive, 2 =    }
                               { Dead, 3 = Online, 4 = In Palace Dungeon) }
Arrived_At       : String[10]; { Time user entered ROK (military time)    }
Taxes            : Boolean;    { If TRUE, user has payed Taxes today      }
Hand             : LongInt;    { Gold on Hand                             }
Bank             : LongInt;    { Gold in the Bank                         }
HP               : LongInt;    { Current HP of the character              }
Max_HP           : LongInt;    { Maximum possible HP (Health Points)      }
Sleep            : Byte;       { Where the character is sleeping (0 = The }
                               { Fields, 1 = Inn, 2 = Palace, 3 = An EGO) }
Rank             : Byte;       { Social Rank (1 = Prince, 2 = Duke, 3 =   }
                               { Squire, 4..6 same, but is for Females)   }
Gender           : Byte;       { Player Gender (1 = Male, 2 = Female)     }
P_Fights         : Integer;    { Player vs. Player Fights left for today  }
M_Fights         : Integer;    { Monster Combat Fights left for today     }
Flirt            : Boolean;    { If TRUE, player has flirted with another }
                               { character already today                  }
Charm            : Integer;    { General good looks of the character      }
Str              : LongInt;    { Character's Strength                     }
Def              : LongInt;    { Character's Defense                      }
EXP              : LongInt;    { Character's Experience                   }
Level            : Integer;    { Level of EXP this character is at        }
Weap_Num         : Integer;    { Weapon Number                            }
Weap_Nam         : String[20]; { Name of the Weapon character is using    }
Arm_Num          : Integer;    { Armour Number                            }
Arm_Nam          : String[20]; { Name of the Armour character is using    }
Guild            : Byte;       { Guild Character belongs to (1 = Paladin, }
                               { 2 = Cleric, 3 = Sorcerer, 4 = Assassin,  }
                               { 5 = Warrior, 6 = Ninja)                  }
GM               : Boolean;    { TRUE if this player is GuildMaster of    }
                               { their Guild                              }
On_Today         : Boolean;    { Has this character already been in ROK   }
                               { today?  If so, then this is TRUE.        }
Master           : Boolean;    { Has this character fought a Level Master }
                               { and Lost/Ran already today?              }
Macbeth          : Boolean;    { Has this character fought Macbeth today? }
Bank_Rob         : Boolean;    { Has this player Robbed the Bank today?   }
Cursed           : Byte;       { Player's Feelings (0 = Normal, 1 =       }
                               { Cursed, 2 = Blessed)                     }
Prayed           : Boolean;    { Has player prayed to Gods already today? }
Married_To       : String[40]; { Who is this character married to? *REAL* }
                               { name of the character.                   }
Sex              : Integer;    { Number of times this character has had   }
                               { sex with another character in the game.  }
Quests           : Integer;    { Total number of Quests this character    }
                               { has completed.                           }
Loot             : Boolean;    { Has this character looted a destroyed    }
                               { shop already today?                      }

End;

{ Below is the record structure for the 200 monsters in ROK. (ROKMON.DAT)      }

MonData = Record

Name     : String[40];
Weapon   : String[40];
Strength : LongInt;
Gold     : LongInt;
Exp      : LongInt;
HP       : LongInt;

End;

{ Below is the record structure for the Level Masters in ROK. (TRAINER.DAT)    }

TrainData = Record

Exp      : LongInt;    { Experience required before player can challenge him }
Name     : String[40]; { Level Master's name }
Weapon   : String[40]; { Name of Master's weapon }
Strength : LongInt;    { Master's strength }
Defense  : LongInt;    { It's defense }
HP       : LongInt;    { Total Hit Points of the Master }

End;

{ Lastly, below is the record structure for EGO's. (EGOS.DAT)                  }

EGOData = Record

EGO_Name   : String[40]; { Name of the EGO }
EGO_Path   : String;     { Path to EGO Executable }
EGO_Cost   : LongInt;    { Cost for Kingdom to construct EGO }
EGO_Built  : Boolean;    { Is this EGO built yet? }
EGO_Desc1,
EGO_Desc2,
EGO_Desc3,
EGO_Desc4  : String[75]; { A four-line max description of this EGO }

End;

{ SOME INFORMATION REGARDING EGO DEVELOPMENT:                                  }
{ We at BFS want to stress the importance of following the set guidelines for  }
{ EGO developers.  When creating your EGO, keep these points in mind:          }
{                             1. A Maximum of 10 EGO's can be in the EGOS.DAT  }
{                                file.  When installing your EGO, check to see }
{                                if 10 EGO's are already installed, to prevent }
{                                possible mix-ups.
{                             2. Please have an option for an uninstall of     }
{                                your EGO.  This must take out ALL the info    }
{                                that your installation procedure entered into }
{                                the EGOS.DAT file -- including description,   }
{                                path, and everything else.                    }
{                             3. One thing to remember upon installation of    }
{                                your EGO is to check if it's already been     }
{                                installed.  Always a good thing.              }
{ That's it!  Or, at least, that's all we can think of at this point.  To get  }
{ your EGO/Utility/3rdParty product on the list in EGOLIST.TXT, refer to the   }
{ bottom of that file for more information.                                    }

{ Upon the exit of ROK to run an EGO, ROKINFO.<x> is created, where <x> is the }
{ node number that the user is on.  ROKINFO.x is a drop file.  As your EGO is  }
{ loading up, if need be, you might want to read in the ROKINFO.x file.  Below }
{ is the format for this file:                                                 }

{      Line 1 ---> Record Number of the user in the PLAYER.DAT file            }
{      Line 2 ---> Graphics Code.  3 = ANSI Graphics, else ASCII.              }
{      Line 3 ---> Time remaining online                                       }
{      Line 4 ---> ROK Alias of the character                                  }
{      Line 5 ---> First *REAL* Name of the user                               }
{      Line 6 ---> Last *REAL* Name of the user                                }
{      Line 7 ---> Com Port the modem is running on                            }
{      Line 8 ---> Actual Baud Rate                                            }
{      Line 9 ---> Locked Baud Rate                                            }

{ That is the format of the ROKINFO.<x> file.  A 9-Line drop file format.      }

{ We'll include a new line (Line 10) in the ROKINFO.<x> file soon.  That'll be }
{ the communications type - Internal/FOSSIL/XFOSSIL.  This should help some of }
{ the developers who're experiencing some comm routine troubles.               }

{ Well, that's all of them!  As mentioned above, if you require assistance in  }
{ regards to the structs shown here, please feel free to contact us anytime.   }

{ Please refer to the EGOLIST.TXT file, included in this archive, for more EGO }
{ and other 3rdParty related products. For your product to be recognized by us }
{ in the EGOLIST.TXT, you must receive the "BFS Stamp of Approval".  More info }
{ is given at the bottom of EGOLIST.TXT.                                       }

{ Best of luck to you and your program(s) from all of us at BFS!               }
{                                                           - The BFS guys     }

Begin
End.
