(*                            RCS Party Time!
                     (c)2021 - RCS Development Team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
*)

Uses 
  User,
  Cfg

Const
  TITLE   = '|15'     // are the titles of each column, i.e. Node, user, location, security level, screen size, etc.
  BAR     = '|08'     // Is the color of the line before and after each title name
  C1      = '|03'     // C1-C7 are the columns of who's online output data   
  C2      = '|11'
  C3      = '|07'
  C4      = '|02'
  C5      = '|09'     // Happy Birthday announcement color
  C6      = '|10'     // New User announcement color
  C7      = '|08'     // menu prompt bracket color
  C8      = '|15'     // menu prompt hot key and text color
  C9      = '|12'     // 'aborted' message color
  DelTime = 1000
  DateForm= 2         //Date Format   1. 01/31 
                      //              2. 31 Jan
                      
// ***** DO NOT EDIT BELOW THIS LINE! *****

  PROG_NAME = 'RCS Party Time!'
  PROG_VER  = '1.0b (RCS)'
  PROG_AUTH = 'RCS Development Team'
  
Type
  UserRecord = Record
  Active     :Boolean
  Name       :String[30]
  Location   :String[30]
  Gender     :Char
  Age        :Byte
  FirstOn    :LongInt;        // Date/Time of First Call Unix
  LastOn     :LongInt;        // Date/Time of Last Call Unix
  Calls      :LongInt;        // Number of calls to BBS
End;

Type
  NewBirthRec = Record
  UNum   : Integer
  Name   : String[30]
  City   : String[30]
  BDay   : Boolean
  BDMon  : Byte
  BDDay  : Byte
  UAge   : Byte
  NewUse : Boolean
  FirstOn: LongInt
End

Var
  U         : Integer = 1   //user loop counter 
  ListUser  :UserRecord 
  age       : string        // string to display age
  sex       : Char     
  Today     : String        // displays todays date xx/xx/xxxx
  lm        : string    
  ld        : string 
  ly        : string 
  bday      : boolean       // if there is a birthday true or false
  birthday  : integer
  bmonth    : integer    
  newuser   : boolean       // new user true or false
  newuser1  : Integer
  a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,z,x,y  : integer       // various data holders
  temp      : String
  Twriters  :array[1..50] of string      // up to 50 one liners can be changed to whatever you want.
  Toneliner :array[1..50] of string      // will be saved and accessible via the previous menu option. 
  NewBirth  :array[1..50] of NewBirthRec // array used to ensure that if there are more then 8 or no new users, what to do with screen formatting
  S         :string 
  Foneline  :string
  Count     :byte
  Count2    :byte
  ml        :byte 
  fptr      :file
  old       :byte=46
  new       :byte=50 
  TimeStart :LongInt

Procedure CheckTimeOut;
Begin
  If CfgTimeOut>0 Then
  Begin
    If Timer-TimeStart>CfgTimeOut Then 
    Begin
      WriteLn(GetPrompt(136));
      SysopLog(PROG_NAME+': Inactivity timeout');
      write('|[1')
      write('[0;0 D');
      HangUp;
    End
  End;
End;

Procedure Clear            //clear previous oneliners and lists new or previous ones
Var
  r  : Byte
Begin
  If TermSizeX=132 then
    For r:=25 to TermSizeY Do WriteXY(1,r,7,'                                                                                                                                    ')
  Else
    For r:=17 to 21 Do WriteXY(1,r,7,'                                                                                ')
End


Procedure show    // displays oneliners
begin
  if TermSizeX=132 then 
    g:=25
  else
    g:=16
  g:=g+1
  For Count := old To new Do
  Begin
    gotoxy(1,g)
    write  (C1+'|[X02')
    write  (padRT(Twriters[count], 15, ' '))
    write  ('|[X18'+C2+'>'+c7+'> '+c3)
    write  (padRT(Toneliner[count], 60, ' '))      
    g:=g+1
  End
  write('|CR')
  if TermSizeX=132 then
    gotoxy(1,32)
  else
    gotoxy(1,22)
  Write(Bar+StrRep('-',TermSizeX-1))
End

Procedure Aborted // animation for clearing the user input field if aborted, prior to displaying the menu command line again
Begin
  If TermsizeX=132 then   // clear user input text and field
  begin
    gotoxy(1,34)
    Write(StrRep(' ',TermSizeX-1))
    gotoxy(1,35)
    Write(StrRep(' ',TermSizeX-1))
  End 
  Else
  Begin 
    Gotoxy(1,23)
    Write(StrRep(' ',TermSizeX-1))
    Gotoxy(1,24)
    Write(StrRep(' ',TermSizeX-1))
  End
  If TermsizeX=132 then   // write aborted with 1000ms delay  
    Gotoxy(1,34)
  Else
    Gotoxy(1,24)
  Write(C9+'Aborted.')
  Delay(1000)
  If TermsizeX=132 then   // write aborted with 1000ms delay  
    Gotoxy(1,34)
  Else
    Gotoxy(1,24)
  Write(StrRep(' ',TermSizeX-1))
End
      
Procedure Menu    // menu command line and it's associated functions
Var
  Ch1  : Char=''
  Ch2  : Char
  Done : Boolean=False
Begin
  write('[0;40 D');
  Ch1:=''
  Repeat
    TimeStart:=Timer
    if TermSizeX=132 then
      gotoxy(1,35)
    else
      gotoxy(1,24)
    Write(C7+' < '+C8+'['+C7+' >'+C8+' Older Messages'+C7+' < '+C8+']'+C7+' >'+C8+' Newer Messages'+C7+' < '+C8+'A'+C7+' >'+C8+' Add a Message '+C7+' < '+C8+'Q'+C7+' >'+C8+' Quit'+C7+': ')
    Repeat
      If Keypressed Then 
        Ch1:=Upper(ReadKey)
      CheckTimeOut
      Delay(100)
    Until Ch1='[' Or Ch1=']' Or Ch1='A' Or Ch1='Q'
  Until Ch1<>''
  Case Ch1 Of
    '[' : Begin  // menu option will display the previous 5 one liners until the last 5 are displayed out of 50, then display animation to prevent break/exit of program.
            if TermsizeX=132 then
              gotoxy(1,19)
            else
              gotoxy(1,17)
            if old > 5 then
            begin
              Clear
              old:= old-5
              new:= new-5
              show
              menu
            end 
            else
            begin
              if TermsizeX=132 then 
              Begin
                gotoxy(1,35)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,35)
                Write('These are the oldest messages.')
                Delay(1000)
                gotoxy(1,35)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,35)
                menu
              End 
              Else
              begin
                gotoxy(1,24)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,24)
                Write('These are the oldest messages.')
                Delay(1000)
                gotoxy(1,24)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,24)
                menu
              End
            end 
          end
 
    ']' : Begin       // menu option will display the next 5 one liners unless at the end of the file, then display animation to prevent break/exit of program.
            if TermsizeX=132 then
              gotoxy(1,19)
            else
              gotoxy(1,17)
            if new < 50 then
            begin
              Clear
              old:= old+5
              new:= new+5
              show
              menu
            end 
            else
            begin
              if TermsizeX=132 then 
              Begin
                gotoxy(1,35)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,35)
                Write('These are the Newest messages.')
                Delay(1000)
                gotoxy(1,35)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,35)
                menu
              End 
              Else
              begin
                gotoxy(1,24)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,24)
                Write('These are the Newest messages.')
                Delay(1000)
                gotoxy(1,24)
                Write(StrRep(' ',TermSizeX-1))
                gotoxy(1,24)
                menu
              End
            end 
          end
  
    'A' : Begin               // removing command line at bottom by term size in place of user input
            if TermSizeX=132 then
              gotoxy(1,35)
            else 
              gotoxy(1,23)
            Write(StrRep(' ',TermSizeX-1))
            if TermSizeX=132 then
              gotoxy(1,35)
            else
              gotoxy(1,24)
            Write(StrRep(' ',TermSizeX-1))
            If Termsizex=132 then  // draw user input to bottom by termsize
              gotoxy(1,34)
            else 
              gotoxy(1,23)
            Writeln(TITLE+'Enter your text here or ENTER to abort.')
            Write  (C1+':')
            s := Input(60, 60, 11, '')
            If s = '' then      // if user inputs "ENTER" or input is blank, then abort back to party time menu
            begin
              aborted
              menu 
            end 
            else // saves users one liner then clears the input field to redisplay the menu command line
            begin 
              For Count := 1 To 49 do
              Begin
                Count2 := Count + 1
                Twriters[count]  := Twriters[count2]
                Toneliner[count] := Toneliner[count2]
              End
              tWriters[50]  := userAlias
              tOneliner[50] := S
              fAssign(fptr,Foneline,66)
              fReWrite(fptr)
              For Count := 1 To 50 do
              Begin
                fWriteLn(fptr, tWriters[count])
                fWriteLn(fptr, tOneliner[count])
              End
              fClose(fptr)
              If Termsizex=132 then
              Begin
                Gotoxy(1,34)
                Write(StrRep(' ',TermSizeX-1))
                Gotoxy(1,35)
                Write(StrRep(' ',TermSizeX-1))
              End 
              Else 
              Begin
                Gotoxy(1,23)
                Write(StrRep(' ',TermSizeX-1))
                Gotoxy(1,24)
                Write(StrRep(' ',TermSizeX-1))
              End
            End
            show
            menu  
          End 
 
  'Q' : Begin
          write('[0;0 D');
          clrscr
          halt
        end
  End
end

Function datemonth(month:Integer):string
Begin
  Case month of
    1 : datemonth:='Jan'
    2 : datemonth:='Feb'
    3 : datemonth:='Mar'
    4 : datemonth:='Apr'
    5 : datemonth:='May'
    6 : datemonth:='Jun'
    7 : datemonth:='Jul'
    8 : datemonth:='Aug'
    9 : datemonth:='Sep'
    10: datemonth:='Oct'
    11: datemonth:='Nov'
    12: datemonth:='Dec'
  End
End

Procedure PartyTime  // looks through entire user list for birthdays and new users, displays up to 7 of them.  if more then 7 exist, the x/y position changes after an animated delay and displays more, if less exist
Var     // the mod will display "no birthdays today and/or Spread the word about "BBS Name" to prevent a blank screen.
  nb       : Integer=1
  count1   : Integer=1
  count3   : Integer=1
  count4   : Integer=1
  done     : Boolean=false
  y1       : Byte
  tempdate : String
  tempmon  : String
  tempday  : String
Begin
  if TermSizeX >=132 then
    Y:=16
  else
    Y:=9
  y1:=y
  today := datestr(datetime,1)
  d:=Str2Int(WordGet(1,datestr(datetime,4),'/'))            
  f:=Str2Int(WordGet(2,datestr(datetime,4),'/'))            
  b:=Str2Int(WordGet(3,datestr(datetime,4),'/'))           
  While GetUser(U) Do   
  Begin     
    c:=Str2Int(WordGet(1,datestrjulian(userbirthday,4),'/'))  //bm
    e:=Str2Int(WordGet(2,datestrjulian(userbirthday,4),'/'))  //bd
    a:=Str2Int(WordGet(3,datestrjulian(userbirthday,4),'/'))  //by
    h :=b - a             
    i :=d - c         
    if i < 0 then 
      h :=h-1
    age := int2str(h)                      
    temp:=PadLt(int2str(c),2,'0')+'/'+PadLt(int2str(e),2,'0')+'/21'  //This should be changed to year variable, not hard coded
    if ((c = d and e = f) Or (DaysAgo(Date2Julian(temp))<=7 And DaysAgo(Date2Julian(temp))>0)) And (Str2Int(age)>5) then 
    begin
      NewBirth[nb].UNum:=U
      NewBirth[nb].Name:=StripMCI(UserAlias)
      NewBirth[nb].City:=StripMCI(UserCity)
      NewBirth[nb].BDay:=true
      NewBirth[nb].BDMon:=c
      NewBIrth[nb].BDDay:=e
      NewBirth[nb].UAge:=Str2Int(age)
      NewBirth[nb].NewUse:=false
      NewBirth[nb].FirstOn:=0
      nb:=nb+1
    end 
    If (DateStr(DateU2D(Userfirston),1) = Today) Or (DaysAgo(Date2Julian(DateStr(DateU2D(Userfirston),1)))<=7) Then
    begin
      NewBirth[nb].UNum:=U
      NewBirth[nb].Name:=StripMCI(UserAlias)
      NewBirth[nb].City:=StripMCI(UserCity)
      NewBirth[nb].BDay:=false
      NewBirth[nb].UAge:=Str2Int(age)
      NewBirth[nb].NewUse:=true
      NewBirth[nb].FirstOn:=UserFirstOn
      nb:=nb+1
    end
    u:=u+1
  end
    if TermSizeX=132 then
      gotoxy(1,35)
    else
      gotoxy(1,24)
    Write(C7+' < '+C8+'['+C7+' >'+C8+' Older Messages'+C7+' < '+C8+']'+C7+' >'+C8+' Newer Messages'+C7+' < '+C8+'A'+C7+' >'+C8+' Add a Message '+C7+' < '+C8+'Q'+C7+' >'+C8+' Quit'+C7+': ')
  GotoXY(1,y)
  If nb=1 Then
  Begin
    WriteLn(C5+'|[X02No Birthdays or New Users in last 7 days')
    WriteLn(C5+'|[X02Spread the word about |BN')
    done:=true
  End
  While count1<nb Do
  Begin
    If NewBirth[count1].BDay Then  //padrt was added to these to clear previous info after the delay
    begin
      If TermsizeX >=132 then
      Begin
        If DateForm=1 Then
          Writeln(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X58'+PadRt(Int2Str(NewBirth[count1].UAge),3,' ')+C1+'|[X76'+PadLt(Int2Str(NewBirth[count1].BDMon),2,'0')+'/'+PadLt(Int2Str(NewBirth[Count1].BDDay),2,'0')+' '+C5+PadCt('|[X100Happy Birthday!!',32,' '))
        Else If DateForm=2 Then
        Begin
          tempmon:=datemonth(NewBirth[Count1].BDMon)
          tempday:=Int2Str(NewBirth[Count1].BDDay)
          Writeln(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X58'+PadRt(Int2Str(NewBirth[count1].UAge),3,' ')+C1+'|[X76'+PadLt(tempday,2,'0')+' '+tempmon+C5+PadCt('|[X100Happy Birthday!!',32,' '))
        End
      End
      else
        WriteLn(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X48'+Int2Str(NewBirth[count1].UAge)+C5+PadCt('|[X59Happy Birthday!! ',23,' '))
      y:=y+1 
    end 
    If NewBirth[count1].NewUse Then
    begin
      If TermSizeX >=132 then
      Begin
        If DateForm=2 Then
        Begin
          tempdate:=Copy(DateStr(DateU2D(UserFirstOn),1),1,5)
          tempmon:=datemonth(Str2Int(WordGet(1,tempdate,'/')))
          tempday:=WordGet(2,tempdate,'/')
          Writeln(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X58'+Int2Str(NewBirth[count1].UAge)+C1+'|[X76'+tempday+' '+tempmon+C6+'|[X100   '+PadRt('|[X103New User!!',32,' '))
        End
        Else If DateForm=1 Then
        Begin
          tempdate:=Copy(DateStr(DateU2D(UserFirstOn),1),1,5)
          Writeln(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X58'+Int2Str(NewBirth[count1].UAge)+C1+'|[X76'+tempdate+C6+'|[X100   '+PadRt('|[X103New User!!',32,' '))
        End
      End
      Else    
        Writeln(C1+' |[X02'+PadRt(int2str(NewBirth[count1].UNum),6,' ')+C2+'|[X11'+PadRt(NewBirth[count1].Name,17,' ')+C3+'|[X28'+PadRt(NewBirth[count1].City,20,' ')+C4+'|[X48'+Int2Str(NewBirth[count1].UAge)+C6+PadRt('|[X59   New User!!',23,' '))
      y:=y+1
    End
    count1:=count1+1
    count4:=count4+1
    If (count4 >= 8)and(count3 <= nb-8) Then 
    Begin
      Delay(DelTime)
      GotoXY(1,y1)
      count3:=count3+1
      count1:=count3
      count4:=1
    End
  End
End

procedure init  // checks to see if the file exists, if not, will create the data file, and write 50 place holders for the one liners so that the screen is not blank.  The place holders will be replaced with 
Begin   // whatever the sysop or users input as congrats or welcomes to bdays or new users.
  GetThisUser
  Foneline := CFGDATAPATH+'rcs1line.lst'
  if not fileExist(fOneLine) then
  Begin
    fAssign(fptr,fOneLine,66)
    fReWrite(fptr)
    For count := 1 To 50 do
    Begin
      fWriteLn(fptr, '|11'+PROG_AUTH)
      fWriteLn(fptr, PROG_NAME+' v'+PROG_VER)
    End
  End
  fClose(fptr)
  fAssign(fptr,Foneline,66)
  fReset(fptr)
  For Count := 1 To 50 do
  Begin
    fReadLn(fptr, Twriters[count])
    fReadLn(fptr, Toneliner[count])
  End
  fClose(fptr)
End

Begin   // executes each of the procedures in the order necessary for the mod to function correctly.
  ClrScr
  write('[0;0 D');
  dispfile('partytime')
  write('[0;40 D');
  if TermsizeX=132 then
  begin
    gotoxy(1,14)
    WriteLn(Title+'|[X02Usr#|[X11User Name|[X28Location|[X58Age|[X73Celebration Date|[X102Celebration')
    WriteLn(Bar+StrRep('-',TermSizeX-1))
    gotoxy(1,17)
  end 
  else
  begin
    gotoxy(1,7)              
    WriteLn(Title+'|[X02Usr#|[X11User Name|[X28Location|[X48Age|[X61Celebration')
    WriteLn(Bar+StrRep('-',TermSizeX-1))
    gotoxy(1,10)
  End
  PartyTime 
  if TermSizeX=132 then
    gotoxy(1,24)
  else
    gotoxy(1,16)
  WriteLn(Bar+StrRep('-',TermSizeX-1))
  Init
  Show
  Menu
  write('[0;0 D');
End.
